export interface Product {
  id: number;
  name: string;
  price: string;
  category: 'Apparel' | 'Detailing' | 'Accessories' | 'Tools';
  image: string;
  description: string;
  inStock: boolean;
  featured: boolean;
  badge?: string;
}

export const products: Product[] = [
  // Apparel
  {
    id: 1,
    name: 'Nine Three Classic Logo Tee',
    price: '$29.99',
    category: 'Apparel',
    image: '/images/products/logo-tee.jpg',
    description: 'Premium cotton t-shirt with embroidered Nine Three logo. Available in black, white, and red.',
    inStock: true,
    featured: true,
    badge: 'Best Seller'
  },
  {
    id: 2,
    name: 'Nine Three Hoodie - Black Edition',
    price: '$59.99',
    category: 'Apparel',
    image: '/images/products/hoodie-black.jpg',
    description: 'Heavy-weight hoodie with premium embroidered logos. Perfect for cool evenings at car meets.',
    inStock: true,
    featured: true
  },
  {
    id: 3,
    name: 'Nine Three Snapback',
    price: '$34.99',
    category: 'Apparel',
    image: '/images/products/snapback.jpg',
    description: 'Classic snapback with 3D embroidered logo. One size fits most.',
    inStock: true,
    featured: false
  },
  {
    id: 4,
    name: 'Mechanic Work Shirt',
    price: '$44.99',
    category: 'Apparel',
    image: '/images/products/work-shirt.jpg',
    description: 'Professional work shirt with Nine Three branding. Durable and comfortable.',
    inStock: true,
    featured: false
  },
  {
    id: 5,
    name: 'Nine Three Beanie',
    price: '$24.99',
    category: 'Apparel',
    image: '/images/products/beanie.jpg',
    description: 'Knitted beanie perfect for winter detailing sessions.',
    inStock: true,
    featured: false
  },

  // Detailing Products
  {
    id: 6,
    name: 'Premium Car Care Kit',
    price: '$89.99',
    category: 'Detailing',
    image: '/images/products/care-kit.jpg',
    description: 'Complete detailing kit including wash, wax, tire shine, and microfiber towels.',
    inStock: true,
    featured: true,
    badge: 'Pro Choice'
  },
  {
    id: 7,
    name: 'Ceramic Coating Kit',
    price: '$149.99',
    category: 'Detailing',
    image: '/images/products/ceramic-coating.jpg',
    description: 'Professional-grade ceramic coating for long-lasting paint protection.',
    inStock: true,
    featured: true,
    badge: 'New'
  },
  {
    id: 8,
    name: 'Microfiber Towel Set (12-Pack)',
    price: '$24.99',
    category: 'Detailing',
    image: '/images/products/microfiber-towels.jpg',
    description: 'Ultra-soft microfiber towels for streak-free cleaning.',
    inStock: true,
    featured: false
  },
  {
    id: 9,
    name: 'Premium Wax Collection',
    price: '$45.99',
    category: 'Detailing',
    image: '/images/products/wax-collection.jpg',
    description: 'Three different wax formulas for various paint types.',
    inStock: true,
    featured: false
  },
  {
    id: 10,
    name: 'Interior Cleaner Spray',
    price: '$19.99',
    category: 'Detailing',
    image: '/images/products/interior-cleaner.jpg',
    description: 'All-purpose interior cleaner safe for all surfaces.',
    inStock: true,
    featured: false
  },
  {
    id: 11,
    name: 'Leather Conditioner',
    price: '$29.99',
    category: 'Detailing',
    image: '/images/products/leather-conditioner.jpg',
    description: 'Premium leather conditioner for maintaining leather seats.',
    inStock: true,
    featured: false
  },
  {
    id: 12,
    name: 'Glass Cleaner Pro',
    price: '$14.99',
    category: 'Detailing',
    image: '/images/products/glass-cleaner.jpg',
    description: 'Streak-free glass cleaner for crystal clear windows.',
    inStock: true,
    featured: false
  },

  // Accessories
  {
    id: 13,
    name: 'Nine Three Vinyl Sticker Pack',
    price: '$12.99',
    category: 'Accessories',
    image: '/images/products/sticker-pack.jpg',
    description: '5-piece vinyl sticker set with various Nine Three designs.',
    inStock: true,
    featured: false
  },
  {
    id: 14,
    name: 'Premium Air Freshener Set',
    price: '$19.99',
    category: 'Accessories',
    image: '/images/products/air-freshener.jpg',
    description: 'Set of 3 premium air fresheners with signature scents.',
    inStock: true,
    featured: false
  },
  {
    id: 15,
    name: 'Nine Three Keychain',
    price: '$9.99',
    category: 'Accessories',
    image: '/images/products/keychain.jpg',
    description: 'Metal keychain with laser-engraved Nine Three logo.',
    inStock: true,
    featured: false
  },
  {
    id: 16,
    name: 'License Plate Frame',
    price: '$24.99',
    category: 'Accessories',
    image: '/images/products/plate-frame.jpg',
    description: 'Custom Nine Three license plate frame. Universal fit.',
    inStock: true,
    featured: false
  },
  {
    id: 17,
    name: 'Phone Mount',
    price: '$34.99',
    category: 'Accessories',
    image: '/images/products/phone-mount.jpg',
    description: 'Universal phone mount with Nine Three branding.',
    inStock: true,
    featured: false
  },

  // Tools
  {
    id: 18,
    name: 'Professional Foam Cannon',
    price: '$79.99',
    category: 'Tools',
    image: '/images/products/foam-cannon.jpg',
    description: 'High-quality foam cannon for pressure washers.',
    inStock: true,
    featured: true
  },
  {
    id: 19,
    name: 'Detailing Brush Set',
    price: '$39.99',
    category: 'Tools',
    image: '/images/products/brush-set.jpg',
    description: 'Complete set of detailing brushes for interior and exterior.',
    inStock: true,
    featured: false
  },
  {
    id: 20,
    name: 'Dual Action Polisher',
    price: '$199.99',
    category: 'Tools',
    image: '/images/products/polisher.jpg',
    description: 'Professional dual-action polisher for paint correction.',
    inStock: false,
    featured: true,
    badge: 'Coming Soon'
  }
];

export const getFeaturedProducts = () => products.filter(p => p.featured);
export const getProductsByCategory = (category: string) =>
  category === 'All' ? products : products.filter(p => p.category === category);
export const getProductById = (id: number) => products.find(p => p.id === id);
